var snake = {
  unit: 10, // the size of a unit in pixels
  window: null,
  board: null,
  messages: null,
  maxMessagesBoardWidth: 25, // units
  setWindow: function() {
    var w = $(window).width();
    var h = $(window).height();
    
    this.window = {
      w: w,
      h: h,
      xUnits: Math.floor(w / this.unit) - 1,
      yUnits: Math.floor(h / this.unit) - 1,
      landscape: (w/h > 1) ? true : false,
      background: '#000'
    };
  },
  setGameAndMessagesBoards: function() {
    var w = this.window.landscape ? (this.maxMessagesBoardWidth < Math.ceil(this.window.xUnits / 2) ? this.maxMessagesBoardWidth : Math.floor(this.window.xUnits / 2)) : this.window.xUnits;
    var h = this.window.landscape ? this.window.yUnits : (this.maxMessagesBoardWidth < Math.ceil(this.window.yUnits / 2) ? this.maxMessagesBoardWidth : Math.floor(this.window.yUnits / 2));
    
    this.messages = {
      w: w,
      h: h,
      x: this.window.landscape ? (this.window.xUnits - w) : 0,
      y: this.window.landscape ? 0 : (this.window.yUnits - h),
      background: '#000',
      border: '1px solid #000',
      position: 'absolute'
    };
    
    w = this.window.landscape ? (this.window.xUnits - w) : this.window.xUnits;
    h = this.window.landscape ? this.window.yUnits : (this.window.yUnits - h);
    this.board = {
      w: w,
      h: h,
      x: 0,
      y: 0,
      background: '#fff',
      border: '1px solid #666',
      position: 'absolute'
    };
  },
  snakeColor: '#f00',
  snake: [[7,4],[6,4],[5,4]], // x,y unit pairs
  direction: 'right',
  snakeInterval: null,
  gameOver: false,
  toPixels: function(s) {
    return Math.ceil(s * this.unit);
  },
  drawBoard: function() {
    this.setWindow();
    this.setGameAndMessagesBoards();
    
    var self = this;
    $('body').css({
      background: self.window.background,
    });
    
    $('body').append($('<div id="messages-board"></div>').css({
      background: self.messages.background,
      position: self.messages.position,
      top: self.toPixels(self.messages.y) + 'px',
      left: self.toPixels(self.messages.x) + 'px',
      height: self.toPixels(self.messages.h) + 'px',
      width: self.toPixels(self.messages.w) + 'px',
      border: self.messages.border
    }));
    
    $('body').append($('<div id="game-board"></div>').css({
      background: self.board.background,
      position: self.board.position,
      top: self.toPixels(self.board.y) + 'px',
      left: self.toPixels(self.board.x) + 'px',
      height: self.toPixels(self.board.h) + 'px',
      width: self.toPixels(self.board.w) + 'px',
      border: self.board.border
    }));
  },
  setStyleSection: function() {
    // Append a style section in the head of the page and set the style for messages. Only the first is visible for now.
    $('head').append($('<style>').text('#messages-board div {display: none; color: #fff;}' + "\n" + '#messages-board div:first-child {display: block;}'));
  },
  drawSnakeUnit: function(unit) {
    var self = this;
    $('#game-board').append($('<div id="snake-unit-' + unit[0] + '-' + unit[1] + '" class="snake-unit"></div>').css({
      position: 'absolute',
      top: self.toPixels(unit[1]) + 'px',
      left: self.toPixels(unit[0]) + 'px',
      height: self.toPixels(1) + 'px', // one unit
      width: self.toPixels(1) + 'px', // one unit
      background: self.snakeColor,
      'border-radius': self.toPixels(0.3) + 'px'
    }));
  },
  drawInitialSnake: function() {
    for (var i = 0; i < this.snake.length; i++) {
      this.drawSnakeUnit(this.snake[i]);
    }
  },
  removeSnakeUnit: function(unit) {
    $('#snake-unit-' + unit[0] + '-' + unit[1]).remove();
  },
  moveRight: function() {
    var newHead = [this.snake[0][0] + 1, this.snake[0][1]];
    if(newHead[0] >= this.board.w) {
      return this.snakeCrash();
    }
    this.snake.unshift(newHead);
    this.drawSnakeUnit(newHead);
    this.removeSnakeUnit(this.snake.pop());
  },
  moveLeft: function() {
    var newHead = [this.snake[0][0] - 1, this.snake[0][1]];
    if(newHead[0] < 0) {
      return this.snakeCrash();
    }
    this.snake.unshift(newHead);
    this.drawSnakeUnit(newHead);
    this.removeSnakeUnit(this.snake.pop());
  },
  moveUp: function() {
    var newHead = [this.snake[0][0], this.snake[0][1] - 1];
    if(newHead[1] < 0) {
      return this.snakeCrash();
    }
    this.snake.unshift(newHead);
    this.drawSnakeUnit(newHead);
    this.removeSnakeUnit(this.snake.pop());
  },
  moveDown: function() {
    var newHead = [this.snake[0][0], this.snake[0][1] + 1];
    if(newHead[1] >= this.board.h) {
      return this.snakeCrash();
    }
    this.snake.unshift(newHead);
    this.drawSnakeUnit(newHead);
    this.removeSnakeUnit(this.snake.pop());
  },
  move: function() {
    switch(this.direction) {
      case 'up':
        this.moveUp();
        break;
      case 'down':
        this.moveDown();
        break;
      case 'left':
        this.moveLeft();
        break;
      case 'right':
        this.moveRight();
        break;
    }
  },
  setDirection: function(keyCode) {
    if (!this.snakeInterval){
      return;
    }
    if (keyCode == 37) {
      this.direction = 'left';
    }
    if (keyCode == 38) {
      this.direction = 'up';
    }
    if (keyCode == 39) {
      this.direction = 'right';
    }
    if (keyCode == 40) {
      this.direction = 'down';
    }
  },
  snakeCrash: function() {
    this.gameOver = true;
    this.stop();
    this.logMessage('Game Over');
    $('.snake-unit').css({
      'background': '#ff0'
    }).fadeOut(500, function(){
      $('.snake-unit').remove();
    });
  },
  start: function() {
    if (this.gameOver) {
      return;
    }
    var self = this;
    this.snakeInterval = setInterval(function() {
      self.move();
    }, 100);
  },
  stop: function() {
    if (this.snakeInterval){
      clearInterval(this.snakeInterval);
    }
    this.snakeInterval = null;
  },
  pauseAndGo: function(keyCode) {
    if (keyCode == 32) { // spacebar is pressed
      if (this.snakeInterval) {
        this.stop();
      } else {
        this.start();
      }
    }
  },
  logMessage: function(message) {
    // Add a new message to message board. 
    $('#messages-board').prepend($('<div>').text(message));
  },
  initialize: function() {
    this.drawBoard();
    this.setStyleSection();
    this.drawInitialSnake();
//    this.start();
  }
};

$(document).ready(function(){
  $(document).on('keyup', function(e){
    var keyCode = e.which;
    snake.setDirection(keyCode);
    snake.pauseAndGo(keyCode);
  });
  snake.initialize(); 
});